/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.ProtectionParameter;
import DE.siemens.ad.logo.model.Reference;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.Timer;
import DE.siemens.ad.logo.model.UnlimitedHours;
import DE.siemens.ad.logo.util.AnalogValueProperties;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Logger.ErrorInfo;
import DE.siemens.ad.logo.util.TimeValueProperties;
import java.awt.HeadlessException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.List;

public class HoursCounterParameter
extends ProtectionParameter {
    private int hoursCounterSerializedDataVersion = 2;
    static final long serialVersionUID = 0L;
    private static final transient int READY = 0;
    private static final transient int RUNNING = 1;
    private static final transient int WAITING = 2;
    protected int fOperatingTime;
    protected transient int fTimeRemaining;
    protected boolean fOutputIndependentOfEn;
    protected transient long fLastCntOt;
    protected transient int fState;
    protected transient long fDiff = 0L;
    private Boolean fExtendedCounter;
    protected int fMaintenanceInterval;
    protected int fOperatingTimeStart;
    private Timer fMI_Timer;
    private Timer fOT_StartTimer;
    private transient int fLastMIMinutes;
    private transient boolean fFirstCycle = true;
    private transient boolean fLastEnabled = false;

    public HoursCounterParameter() {
    }

    public HoursCounterParameter(Block block) {
        super(block);
        long currentTime;
        this.setRemanenceAvailable(true);
        this.getRemanenceObject().setRemanence(true);
        this.fParameter = 2;
        this.fAllocatedTimer = 0;
        this.fData = 4;
        this.fOperatingTime = 0;
        this.fLastCntOt = currentTime = new Date().getTime();
        this.fDiff = 0L;
    }

    protected boolean calculateValue(boolean reset, boolean enable, boolean resetAll) {
        if (this.isExtendedCounter()) {
            return this.calculateValueNew(reset, enable, resetAll);
        }
        return this.calculateValueOld(reset, enable, resetAll);
    }

    private boolean isExtendedCounter() {
        this.fExtendedCounter = null;
        if (this.fExtendedCounter == null) {
            this.fExtendedCounter = new Boolean(this.getBlock().getWiringDiagram().getHardware().supports("extHourscounter"));
        }
        return this.fExtendedCounter;
    }

    private boolean calculateValueOld(boolean reset, boolean enable, boolean resetAll) {
        boolean result = false;
        long currentTime = this.fInterpreter.getCurrentSimulationClockTime();
        if (resetAll) {
            this.fOperatingTime = 0;
            this.fTimeRemaining = this.getMI_Minute();
            this.fLastCntOt = currentTime;
            this.fState = 0;
        } else {
            if (reset) {
                this.fTimeRemaining = this.getMI_Minute();
            }
            if (enable) {
                int duration;
                this.fState = 1;
                if (this.fTimeRemaining == 0) {
                    result = true;
                }
                if ((duration = (int)(currentTime - this.fLastCntOt) / 60000) >= 1) {
                    this.fOperatingTime += duration;
                    this.fTimeRemaining -= duration;
                    if (this.fTimeRemaining < 0) {
                        this.fTimeRemaining = 0;
                    }
                    this.fLastCntOt = currentTime - (currentTime - this.fLastCntOt) % 60000L;
                }
            } else if (this.fState == 1) {
                this.fDiff = currentTime - this.fLastCntOt;
                this.fState = 2;
            } else {
                this.fLastCntOt = this.fState == 2 ? currentTime - this.fDiff : currentTime;
            }
        }
        return result;
    }

    private boolean calculateValueNew(boolean reset, boolean enable, boolean resetAll) {
        long currentTime = this.fInterpreter.getCurrentSimulationClockTime();
        if (this.fLastMIMinutes != this.getMI_Minute()) {
            if (this.fFirstCycle) {
                this.initTimeRemaining();
                this.fFirstCycle = false;
            } else {
                this.updateMNAcordingToMI();
            }
            this.fLastMIMinutes = this.getMI_Minute();
        }
        boolean result = false;
        if (resetAll) {
            this.setOTStart_Minute(0);
            this.fOperatingTime = 0;
            this.fTimeRemaining = this.getMI_Minute();
            this.fLastCntOt = currentTime;
            this.fState = 0;
            this.fireParameterSetEvent();
        } else {
            if (this.isOutputIndependentOfEn().booleanValue()) {
                result = this.fLastBinaryValue;
            }
            if (reset) {
                this.fTimeRemaining = this.getMI_Minute();
                result = false;
                this.fState = 2;
            }
            if (enable || this.fLastEnabled) {
                int duration;
                if (this.fState != 1) {
                    this.fState = 1;
                    this.fLastCntOt = currentTime;
                }
                if (this.fTimeRemaining == 0) {
                    result = true;
                }
                if ((duration = (int)(currentTime - this.fLastCntOt) / 60000) >= 1) {
                    this.fOperatingTime += duration;
                    this.fTimeRemaining -= duration;
                    if (this.fTimeRemaining < 0) {
                        this.fTimeRemaining = 0;
                    }
                    this.fLastCntOt = currentTime - (currentTime - this.fLastCntOt) % 60000L;
                }
            } else {
                this.fState = 2;
            }
        }
        this.fLastEnabled = enable;
        this.fLastBinaryValue = result;
        return result;
    }

    public int getAllocatedRAM() {
        return 0;
    }

    public int getAllocatedREM() {
        return this.fData;
    }

    public Integer getOperatingTime() {
        return new Integer(this.fOperatingTime / 60);
    }

    public TimeUnit getOTProperties() {
        UnlimitedHours ot = new UnlimitedHours(99999);
        ot.setTime(this.fOperatingTime / 60, this.fOperatingTime % 60);
        return ot;
    }

    public void setOperatingTime(Integer time) {
        this.fOperatingTime = time * 60;
    }

    public String calculateCurrentParameterText() {
        String miValue = this.getMITimer().getParamTime().getParameterText();
        miValue = this.extendToSameLength(miValue);
        String mnValue = this.getMNProperties().getParameterText();
        mnValue = this.extendToSameLength(mnValue);
        String otValue = this.getOTProperties().getParameterText();
        otValue = this.extendToSameLength(otValue);
        return "MI=" + miValue + "\nMN=" + mnValue + "\nOT=" + otValue;
    }

    private String extendToSameLength(String preStr) {
        if (preStr != null && preStr.length() <= 8) {
            return "         ".substring(preStr.length()) + preStr;
        }
        return preStr;
    }

    private Timer GetUnlimitedHoursTimer(String nameKey, int highMax) {
        Timer timer = new Timer(nameKey);
        this.setAvailableTimeUnitToUnlimited(timer, highMax);
        timer.setParamTime(timer.getAvailableTimeUnitObjects()[0]);
        return timer;
    }

    private void setAvailableTimeUnitToUnlimited(Timer timer, int highMax) {
        TimeUnit[] availableTimeUnits = new TimeUnit[]{new UnlimitedHours(highMax)};
        timer.setAvailableTimeUnits(availableTimeUnits);
    }

    public Timer getMITimer() {
        if (this.fMI_Timer == null) {
            this.fMI_Timer = this.GetUnlimitedHoursTimer("dialog.parameter.hoursCounter.maintenanceInterval", 9999);
            this.setMI_Minute(0);
        }
        if (this.fMI_Timer.getAvailableTimeUnitObjects().length > 1) {
            this.setAvailableTimeUnitToUnlimited(this.fMI_Timer, 9999);
            System.err.println("Timebase for MI error.");
        }
        if (this.fMI_Timer.getParamTime() instanceof Reference) {
            Reference ref = (Reference)this.fMI_Timer.getParamTime();
            if (ref.getTimeUnit().fHighMax != 9999) {
                ref.setTimeUnit(new UnlimitedHours(9999));
            }
        }
        return this.fMI_Timer;
    }

    public int getMI_Minute() {
        return (int)(this.getMITimer().getParamTime().getMilliseconds() / 60000L);
    }

    public AnalogValueProperties getMaintenanceInterval() {
        return new AnalogValueProperties(0, 9999, 1, this.getMITimer().getParamTimeProperties().getCurrentValue().getHigh().getCurrentValue(), 0, true, "error.dialog.invalidValue", "Invalid value.");
    }

    public void setMaintenanceInterval(AnalogValueProperties newValue) {
        this.setMaintenanceInterval(newValue.getCurrentValue());
    }

    public TimeValueProperties getMIProperties() {
        TimeValueProperties props = this.getMITimer().getParamTimeProperties();
        props.setParameter(this);
        return props;
    }

    public Timer getOTStartTimer() {
        if (this.fOT_StartTimer == null) {
            this.fOT_StartTimer = this.GetUnlimitedHoursTimer("dialog.parameter.hoursCounter.totalTimeStart", 99999);
            this.setOTStart_Minute(0);
        }
        if (this.fOT_StartTimer.getAvailableTimeUnitObjects().length > 1) {
            this.setAvailableTimeUnitToUnlimited(this.fOT_StartTimer, 99999);
            System.err.println("Timebase for start_OT error.");
        }
        return this.fOT_StartTimer;
    }

    public int getOTStart_Minute() {
        return (int)(this.getOTStartTimer().getParamTime().getMilliseconds() / 60000L);
    }

    public TimeValueProperties getOperatingTimeStart() {
        TimeValueProperties props = this.getOTStartTimer().getParamTimeProperties();
        props.setParameter(this);
        return props;
    }

    public String getParameterText() {
        StringBuffer buffer = new StringBuffer(50);
        buffer.append("MI=").append(this.getMITimer().getParamTime().getParameterText()).append(this.getProtectionSign());
        if (this.isExtendedCounter()) {
            buffer.append("\nOT=").append(this.getOTStartTimer().getParamTime().getParameterText()).append("\nQ->0=").append(this.isOutputIndependentOfEn() != false ? "R" : "R+En");
        }
        return buffer.toString();
    }

    public boolean getValue(boolean reset, boolean enable, boolean resetAll) {
        boolean rw = this.calculateValue(reset, enable, resetAll);
        this.fCurrentParameterText = this.calculateCurrentParameterText();
        this.fireParameterUpdateEvent();
        return rw;
    }

    public Integer getTimeRemaining() {
        return new Integer((int)Math.ceil((double)this.fTimeRemaining / 60.0));
    }

    public TimeUnit getMNProperties() {
        UnlimitedHours mn = new UnlimitedHours(9999);
        mn.setTime(this.fTimeRemaining / 60, this.fTimeRemaining % 60);
        return mn;
    }

    public void setTimeRemaining(Integer newValue) {
        this.fTimeRemaining = newValue * 60;
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        super.init(interpreter, forceReset);
        this.getMITimer().init(interpreter);
        this.fLastCntOt = this.fInterpreter.getCurrentSimulationClockTime();
        if (forceReset) {
            if (!this.isExtendedCounter()) {
                this.fTimeRemaining = this.getMI_Minute();
                this.fOperatingTime = 0;
                this.fState = 0;
                this.fDiff = 0L;
                this.fLastMIMinutes = 0;
            } else {
                this.fOperatingTime = this.getOTStart_Minute();
                this.initTimeRemaining();
                this.fState = 0;
                this.fLastMIMinutes = 0;
                this.fFirstCycle = true;
            }
        }
    }

    public void setMaintenanceInterval(int mi_Hour) {
        int mi = mi_Hour * 60;
        if (!this.isExtendedCounter()) {
            this.setMI_Minute(mi);
            this.fTimeRemaining = mi;
        } else {
            this.setMI_Minute(mi);
            if (this.fInterpreter != null && this.fInterpreter.getStateMachine().isRunning()) {
                this.fTimeRemaining = mi;
            } else {
                this.initTimeRemaining();
            }
        }
    }

    public void updateMNAcordingToMI() {
        if (this.fInterpreter != null && this.fInterpreter.getStateMachine().isRunning()) {
            this.fTimeRemaining = this.getMI_Minute();
        } else {
            this.initTimeRemaining();
        }
    }

    public void setMIProperties(TimeValueProperties newTimeProp) {
        newTimeProp.setParameter(this);
        this.getMITimer().setParamTimeProperties(newTimeProp);
        this.fTimeRemaining = newTimeProp.getCurrentValue().getHigh().getCurrentValue() * 60 + newTimeProp.getCurrentValue().getLow().getCurrentValue();
    }

    private void setMI_Minute(int mi) {
        UnlimitedHours miTime = new UnlimitedHours(9999);
        miTime.setTime(mi);
        this.getMITimer().setParamTime(miTime);
    }

    public Boolean isOutputIndependentOfEn() {
        return this.fOutputIndependentOfEn;
    }

    public boolean isAvailable(Hardware hardware, List errorList) {
        boolean result = super.isAvailable(hardware, errorList);
        if (this.getMITimer().getParamTimeProperties().isReference() && !hardware.supports("HoursCounter_ref")) {
            errorList.add(new ErrorInfo(this, Language.getString("error.hardware.referenceNotSupported", "The reference is not supported by the device %.", hardware.getLocalizedPath() + hardware.getLocalizedName()), hardware));
            return false;
        }
        if (this.getOTStart_Minute() != 0 && !hardware.supports("extHourscounter")) {
            errorList.add(new ErrorInfo(this, "error.convert.hoursCounter.operatingTimeStart", hardware));
            return false;
        }
        if (this.isOutputIndependentOfEn().booleanValue() && !hardware.supports("extHourscounter")) {
            errorList.add(new ErrorInfo(this, "error.convert.hoursCounter.outputEnIndependent", hardware));
            return false;
        }
        if (!(this.getOTStart_Minute() % 60 == 0 && this.getMI_Minute() % 60 == 0 || hardware.supports("hoursCounterTimebase"))) {
            errorList.add(new ErrorInfo(this, "error.convert.hoursCounter.timebase", hardware));
            return false;
        }
        return result;
    }

    public void setOutputIndependentOfEn(Boolean outputBehavior) {
        this.fOutputIndependentOfEn = outputBehavior;
    }

    public void setOperatingTimeStart(int operatingTimeStart) {
        if (this.isExtendedCounter()) {
            this.setOTStart_Minute(operatingTimeStart);
            if (this.fInterpreter != null && !this.fInterpreter.getStateMachine().isRunning()) {
                this.fOperatingTime = operatingTimeStart;
                this.initTimeRemaining();
            }
        }
    }

    public void setOperatingTimeStart(TimeValueProperties value) {
        this.getOTStartTimer().setParamTime(value.getCurrentValue());
    }

    private void setOTStart_Minute(int otStart) {
        UnlimitedHours otTime = new UnlimitedHours(99999);
        otTime.setTime(otStart);
        this.getOTStartTimer().setParamTime(otTime);
    }

    private void initTimeRemaining() {
        this.fTimeRemaining = !this.isExtendedCounter() ? this.getMI_Minute() : (this.getMI_Minute() > 0 ? this.getMI_Minute() - this.fOperatingTime % this.getMI_Minute() : 0);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException, HeadlessException {
        s.defaultReadObject();
        if (!this.getRemanenceAvailable()) {
            this.setRemanenceAvailable(true);
            this.getRemanenceObject().setRemanence(true);
        }
        if (this.hoursCounterSerializedDataVersion < 2) {
            this.hoursCounterSerializedDataVersion = 2;
        }
        if (!this.getMITimer().getParamTimeProperties().isReference() && this.fMaintenanceInterval != this.getMI_Minute() / 60) {
            this.setMI_Minute(this.fMaintenanceInterval * 60);
        }
        this.setOTStart_Minute(this.fOperatingTimeStart);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.fMaintenanceInterval = this.getMI_Minute() / 60;
        this.fOperatingTimeStart = this.getOTStart_Minute();
        s.defaultWriteObject();
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fOperatingTime = dr.readInt();
        this.fMI_Timer = (Timer)dr.readStorable();
        this.setAvailableTimeUnitToUnlimited(this.fMI_Timer, 9999);
        this.fTimeRemaining = dr.readInt();
        this.fLastCntOt = dr.readLong();
        this.fDiff = dr.readLong();
        this.fOT_StartTimer = (Timer)dr.readStorable();
        this.setAvailableTimeUnitToUnlimited(this.fOT_StartTimer, 99999);
        this.fOutputIndependentOfEn = dr.readBoolean();
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fOperatingTime);
        dw.writeStorable(this.getMITimer());
        dw.writeInt(this.fTimeRemaining);
        dw.writeLong(this.fLastCntOt);
        dw.writeLong(this.fDiff);
        dw.writeStorable(this.getOTStartTimer());
        dw.writeBoolean(this.fOutputIndependentOfEn);
    }
}

